/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.another_furniture.block;

import com.starfish_studios.another_furniture.block.properties.HorizontalConnectionType;
import com.starfish_studios.another_furniture.block.properties.ModBlockStateProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class LatticeBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape EAST = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST = Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)0.01, (double)16.0, (double)16.0, (double)2.0);
    protected static final VoxelShape NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<HorizontalConnectionType> TYPE = ModBlockStateProperties.HORIZONTAL_CONNECTION_TYPE;

    public LatticeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(TYPE, (Comparable)((Object)HorizontalConnectionType.SINGLE)));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction clickedFacingFace;
        Level level = context.m_43725_();
        Direction facing = context.m_8125_().m_122424_();
        BlockPos clickedPos = context.m_8083_();
        Direction clickedFace = context.m_43719_();
        BlockPos clickedFacingPos = clickedPos.m_121945_(clickedFace.m_122424_());
        BlockState clickedFacingState = level.m_8055_(clickedFacingPos);
        if (!context.m_43723_().m_6047_() && clickedFacingState.m_60734_() instanceof LatticeBlock && (clickedFacingFace = (Direction)clickedFacingState.m_61143_((Property)FACING)) != clickedFace && clickedFacingFace.m_122424_() != clickedFace) {
            facing = clickedFacingFace;
        }
        BlockState state = this.getConnection((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing), (LevelAccessor)level, clickedPos);
        return (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(clickedPos).m_76152_() == Fluids.f_76193_));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.WEST -> WEST;
            case Direction.EAST -> EAST;
            case Direction.SOUTH -> SOUTH;
            default -> NORTH;
        };
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return this.getConnection(state, level, currentPos);
    }

    public BlockState getConnection(BlockState state, LevelAccessor level, BlockPos currentPos) {
        boolean sideR;
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockState stateL = level.m_8055_(currentPos.m_121945_(facing.m_122427_()));
        BlockState stateR = level.m_8055_(currentPos.m_121945_(facing.m_122428_()));
        boolean sideL = stateL.m_60734_() instanceof LatticeBlock && (stateL.m_61143_((Property)FACING) == facing || stateL.m_61143_((Property)FACING) == facing.m_122427_());
        boolean bl = sideR = stateR.m_60734_() instanceof LatticeBlock && (stateR.m_61143_((Property)FACING) == facing || stateR.m_61143_((Property)FACING) == facing.m_122428_());
        HorizontalConnectionType type = sideL && sideR ? HorizontalConnectionType.MIDDLE : (sideR ? HorizontalConnectionType.LEFT : (sideL ? HorizontalConnectionType.RIGHT : HorizontalConnectionType.SINGLE));
        return (BlockState)state.m_61124_(TYPE, (Comparable)((Object)type));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, TYPE, WATERLOGGED});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }
}

