/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.another_furniture.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.starfish_studios.another_furniture.block.FlowerBoxBlock;
import com.starfish_studios.another_furniture.block.entity.FlowerBoxBlockEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FlowerBoxRenderer
implements BlockEntityRenderer<FlowerBoxBlockEntity> {
    private BlockRenderDispatcher blockRenderer;

    public FlowerBoxRenderer(BlockEntityRendererProvider.Context context) {
        this.blockRenderer = context.m_173584_();
    }

    public void render(FlowerBoxBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Direction facing = ((Direction)blockEntity.m_58900_().m_61143_((Property)FlowerBoxBlock.FACING)).m_122424_();
        float rotation = -facing.m_122435_();
        BlockState upper = null;
        poseStack.m_85836_();
        poseStack.m_85841_(0.7f, 0.7f, 0.7f);
        poseStack.m_252880_(0.0f, 0.4f, 0.0f);
        for (int i = 0; i < 2; ++i) {
            BlockState lower;
            Item item = blockEntity.getItemFromSlot(i);
            if (item == Items.f_41852_) continue;
            Block block = ((BlockItem)item).m_40614_();
            if (block instanceof DoublePlantBlock) {
                lower = (BlockState)block.m_49966_().m_61124_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER);
                upper = (BlockState)block.m_49966_().m_61124_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.UPPER);
            } else {
                lower = block.m_49966_();
            }
            poseStack.m_85836_();
            poseStack.m_252781_(Axis.f_252436_.m_252977_(rotation));
            poseStack.m_85837_((double)0.6f - 0.8 * (double)i, (double)(0.001f * (float)i), (double)0.2f);
            poseStack.m_252880_(0.0f, 0.001f * (float)i, 0.001f * (float)i);
            switch ((Direction)blockEntity.m_58900_().m_61143_((Property)FlowerBoxBlock.FACING)) {
                case EAST: {
                    poseStack.m_252880_(0.0f, 0.0f, -1.4f);
                    break;
                }
                case WEST: {
                    poseStack.m_252880_(-1.4f, 0.0f, 0.0f);
                    break;
                }
                case SOUTH: {
                    poseStack.m_252880_(-1.4f, 0.0f, -1.4f);
                }
            }
            if (((Boolean)blockEntity.m_58900_().m_61143_((Property)FlowerBoxBlock.ATTACHED)).booleanValue()) {
                poseStack.m_252880_(0.0f, 0.9f, 0.36f);
            }
            this.blockRenderer.m_110912_(lower, poseStack, bufferSource, packedLight, OverlayTexture.f_118083_);
            if (upper != null) {
                poseStack.m_252880_(0.0f, 1.0f, 0.0f);
                this.blockRenderer.m_110912_(upper, poseStack, bufferSource, packedLight, OverlayTexture.f_118083_);
            }
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }
}

