/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.corelib.client.obj;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.maxhenkel.camera.corelib.client.obj.OBJModelInstance;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public abstract class OBJEntityRenderer<T extends Entity>
extends EntityRenderer<T> {
    protected OBJEntityRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    public abstract List<OBJModelInstance<T>> getModels(T var1);

    public ResourceLocation m_5478_(T entity) {
        return null;
    }

    public void m_7392_(T entity, float yaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        this.renderModels(entity, yaw, partialTicks, matrixStack, buffer, packedLight);
        super.m_7392_(entity, yaw, partialTicks, matrixStack, buffer, packedLight);
    }

    protected void renderModels(T entity, float yaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        List<OBJModelInstance<T>> models = this.getModels(entity);
        matrixStack.m_85836_();
        this.setupYaw(entity, yaw, matrixStack);
        this.setupPitch(entity, partialTicks, matrixStack);
        for (OBJModelInstance<T> model : models) {
            matrixStack.m_85836_();
            matrixStack.m_85837_(model.getOptions().getOffset().x, model.getOptions().getOffset().y, model.getOptions().getOffset().z);
            if (model.getOptions().getRotation() != null) {
                model.getOptions().getRotation().applyRotation(matrixStack);
            }
            if (model.getOptions().getOnRender() != null) {
                model.getOptions().getOnRender().onRender(entity, matrixStack, partialTicks);
            }
            model.getModel().render(model.getOptions().getTexture(), matrixStack, buffer, packedLight);
            matrixStack.m_85849_();
        }
        matrixStack.m_85849_();
    }

    protected void setupYaw(T entity, float yaw, PoseStack matrixStack) {
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - yaw));
    }

    protected void setupPitch(T entity, float partialTicks, PoseStack matrixStack) {
        float pitch = ((Entity)entity).f_19860_ + (entity.m_146909_() - ((Entity)entity).f_19860_) * partialTicks;
        matrixStack.m_252781_(Axis.f_252495_.m_252977_(pitch));
    }
}

