/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.net;

import de.maxhenkel.camera.corelib.net.Message;
import de.maxhenkel.camera.entities.ImageEntity;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.network.NetworkEvent;

public class MessageResizeFrame
implements Message<MessageResizeFrame> {
    private UUID uuid;
    private Direction direction;
    private boolean larger;

    public MessageResizeFrame() {
    }

    public MessageResizeFrame(UUID uuid, Direction direction, boolean larger) {
        this.uuid = uuid;
        this.direction = direction;
        this.larger = larger;
    }

    @Override
    public Dist getExecutingSide() {
        return Dist.DEDICATED_SERVER;
    }

    @Override
    public void executeServerSide(NetworkEvent.Context context) {
        ServerLevel world;
        Entity entity;
        if (context.getSender().m_9236_() instanceof ServerLevel && context.getSender().m_150110_().f_35938_ && (entity = (world = (ServerLevel)context.getSender().m_9236_()).m_8791_(this.uuid)) instanceof ImageEntity) {
            ImageEntity image = (ImageEntity)entity;
            image.resize(this.direction, this.larger);
        }
    }

    @Override
    public MessageResizeFrame fromBytes(FriendlyByteBuf buf) {
        this.uuid = buf.m_130259_();
        this.direction = Direction.values()[buf.readInt()];
        this.larger = buf.readBoolean();
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.uuid);
        buf.writeInt(this.direction.ordinal());
        buf.writeBoolean(this.larger);
    }

    public static enum Direction {
        UP,
        DOWN,
        LEFT,
        RIGHT;

    }
}

