/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.cannon;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.mehvahdjukaar.moonlight.api.client.util.VertexUtil;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.client.ModMaterials;
import net.mehvahdjukaar.supplementaries.client.ModRenderTypes;
import net.mehvahdjukaar.supplementaries.client.cannon.CannonController;
import net.mehvahdjukaar.supplementaries.client.cannon.CannonTrajectory;
import net.mehvahdjukaar.supplementaries.client.cannon.ShootingMode;
import net.mehvahdjukaar.supplementaries.common.block.tiles.CannonBlockTile;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class CannonTrajectoryRenderer {
    public static void render(CannonBlockTile blockEntity, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay, float partialTicks) {
        BlockHitResult bh;
        HitResult hitResult;
        if (CannonController.cannon != blockEntity) {
            return;
        }
        if (CannonController.hit == null || CannonController.trajectory == null || !CannonController.showsTrajectory) {
            return;
        }
        boolean rendersRed = !blockEntity.readyToFire();
        BlockPos cannonPos = blockEntity.m_58899_();
        Minecraft mc = Minecraft.m_91087_();
        boolean debug = !mc.m_91299_() && mc.m_91290_().m_114377_();
        poseStack.m_85836_();
        float yaw = blockEntity.getYaw(partialTicks) * ((float)Math.PI / 180);
        Vec3 targetVector = CannonController.hit.m_82450_().m_82546_(cannonPos.m_252807_());
        Vec2 target = new Vec2((float)Mth.m_184645_((double)targetVector.f_82479_, (double)targetVector.f_82481_), (float)targetVector.f_82480_);
        poseStack.m_85837_(0.5, 0.5, 0.5);
        poseStack.m_252781_(Axis.f_252436_.m_252961_(-yaw));
        if (debug) {
            CannonTrajectoryRenderer.renderTargetLine(poseStack, buffer, target);
        }
        boolean hitAir = CannonController.shootingMode == ShootingMode.STRAIGHT || mc.f_91073_.m_8055_(CannonController.trajectory.getHitPos(cannonPos, yaw)).m_60795_();
        CannonTrajectoryRenderer.renderArrows(poseStack, buffer, partialTicks, CannonController.trajectory, hitAir, rendersRed);
        poseStack.m_85849_();
        if (!hitAir && (hitResult = CannonController.hit) instanceof BlockHitResult && (bh = (BlockHitResult)hitResult).m_82434_() == Direction.UP) {
            CannonTrajectoryRenderer.renderTargetCircle(poseStack, buffer, yaw, rendersRed);
        }
        if (!hitAir && debug && (hitResult = CannonController.hit) instanceof BlockHitResult) {
            bh = (BlockHitResult)hitResult;
            CannonTrajectoryRenderer.renderTargetBlock(poseStack, buffer, cannonPos, bh);
        }
    }

    private static void renderTargetBlock(PoseStack poseStack, MultiBufferSource buffer, BlockPos pos, BlockHitResult bh) {
        poseStack.m_85836_();
        BlockPos targetPos = bh.m_82425_();
        VertexConsumer lines = buffer.m_6299_(RenderType.m_110504_());
        Vec3 distance1 = targetPos.m_252807_().m_82546_(pos.m_252807_());
        AABB bb = new AABB(distance1, distance1.m_82520_(1.0, 1.0, 1.0)).m_82400_(0.01);
        LevelRenderer.m_109646_((PoseStack)poseStack, (VertexConsumer)lines, (AABB)bb, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    private static void renderTargetCircle(PoseStack poseStack, MultiBufferSource buffer, float yaw, boolean red) {
        poseStack.m_85836_();
        Material circleMaterial = red ? ModMaterials.CANNON_TARGET_RED_MATERIAL : ModMaterials.CANNON_TARGET_MATERIAL;
        VertexConsumer circleBuilder = circleMaterial.m_119194_(buffer, RenderType::m_110452_);
        Vec3 targetVec = new Vec3(0.0, (double)CannonController.trajectory.point().f_82471_, (double)(-CannonController.trajectory.point().f_82470_)).m_82524_(-yaw);
        poseStack.m_85837_(targetVec.f_82479_ + 0.5, targetVec.f_82480_ + 0.5 + 0.05, targetVec.f_82481_ + 0.5);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        int lu = 240;
        int lv = 0xF00000;
        VertexUtil.addQuad((VertexConsumer)circleBuilder, (PoseStack)poseStack, (float)-2.0f, (float)-2.0f, (float)2.0f, (float)2.0f, (int)lu, (int)lv);
        poseStack.m_85849_();
    }

    private static void renderTargetLine(PoseStack poseStack, MultiBufferSource buffer, Vec2 target) {
        VertexConsumer consumer = buffer.m_6299_(RenderType.m_110504_());
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        Matrix3f matrix3f = poseStack.m_85850_().m_252943_();
        consumer.m_252986_(matrix4f, 0.0f, 0.0f, 0.0f).m_6122_(255, 0, 0, 255).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix4f, 0.0f, target.f_82471_, -target.f_82470_).m_6122_(255, 0, 0, 255).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix4f, 0.01f, target.f_82471_, -target.f_82470_).m_6122_(255, 0, 0, 255).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix4f, 0.01f, 0.0f, 0.0f).m_6122_(255, 0, 0, 255).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
    }

    private static void renderArrows(PoseStack poseStack, MultiBufferSource buffer, float partialTicks, CannonTrajectory trajectory, boolean hitAir, boolean red) {
        float finalTime = (float)trajectory.finalTime();
        if (finalTime > 100000.0f) {
            Supplementaries.error();
            return;
        }
        poseStack.m_85836_();
        float scale = 1.0f;
        float size = 0.15625f * scale;
        VertexConsumer consumer = buffer.m_6299_(red ? ModRenderTypes.CANNON_TRAJECTORY_RED : ModRenderTypes.CANNON_TRAJECTORY);
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        float py = 0.0f;
        float px = 0.0f;
        float d = (float)(-(System.currentTimeMillis() % 1000L)) / 1000.0f;
        float step = finalTime / (float)((int)finalTime);
        float maxT = finalTime + (hitAir ? 0.0f : step);
        for (float t = step; t < maxT; t += step) {
            float textureStart = d % 1.0f;
            consumer.m_252986_(matrix, -size, py, px).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, textureStart).m_5752_();
            consumer.m_252986_(matrix, size, py, px).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.3125f, textureStart).m_5752_();
            double ny = trajectory.getY(t);
            double nx = -trajectory.getX(t);
            float dis = (float)Mth.m_184645_((double)(nx - (double)px), (double)(ny - (double)py)) / scale;
            float textEnd = textureStart + dis;
            d += dis;
            py = (float)ny;
            px = (float)nx;
            boolean alpha = !(t + step >= maxT);
            consumer.m_252986_(matrix, size, py, px).m_85950_(1.0f, 1.0f, 1.0f, (float)alpha).m_7421_(0.3125f, textEnd).m_5752_();
            consumer.m_252986_(matrix, -size, py, px).m_85950_(1.0f, 1.0f, 1.0f, (float)alpha).m_7421_(0.0f, textEnd).m_5752_();
        }
        poseStack.m_85849_();
    }
}

