/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.entities.funny;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mehvahdjukaar.supplementaries.client.renderers.entities.funny.PickleData;
import net.mehvahdjukaar.supplementaries.reg.ClientRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTextures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;

public class JarredHeadLayer<T extends Player, M extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    private final ModelPart eyeLeft;
    private final ModelPart eyeRight;
    private final ModelPart head;
    private final ModelPart model;

    public JarredHeadLayer(RenderLayerParent<T, M> renderLayerParent, EntityModelSet entityModelSet) {
        super(renderLayerParent);
        this.model = entityModelSet.m_171103_(ClientRegistry.JAR_MODEL);
        this.head = this.model.m_171324_("head");
        this.eyeLeft = this.head.m_171324_("left_eye");
        this.eyeRight = this.head.m_171324_("right_eye");
    }

    public static LayerDefinition createMesh() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 44).m_171481_(-5.0f, -2.0f, -5.0f, 10.0f, 10.0f, 10.0f).m_171514_(40, 0).m_171481_(-3.0f, -4.001f, -3.0f, 6.0f, 3.0f, 6.0f).m_171514_(0, 24).m_171481_(-4.0f, -1.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.f_171404_);
        PartDefinition head = root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(42, 10).m_171506_(-3.0f, -2.999f, -1.5f, 6.0f, 3.0f, 3.0f, false).m_171514_(45, 12).m_171506_(-2.0f, -2.999f, 1.5f, 4.0f, 3.0f, 1.0f, false).m_171514_(40, 16).m_171506_(-2.0f, 0.0f, -0.5f, 4.0f, 1.0f, 3.0f, false).m_171514_(40, 20).m_171506_(-1.0f, 1.0f, 0.5f, 2.0f, 1.0f, 2.0f, false), PartPose.m_171419_((float)0.0f, (float)5.0f, (float)0.0f));
        head.m_171599_("left_eye", CubeListBuilder.m_171558_().m_171514_(30, 6).m_171506_(-3.0f, -1.0f, -2.499f, 2.0f, 2.0f, 2.0f, false), PartPose.f_171404_);
        head.m_171599_("right_eye", CubeListBuilder.m_171558_().m_171514_(30, 6).m_171506_(1.0f, 0.0f, -2.499f, 2.0f, 2.0f, 2.0f, false), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)64);
    }

    public void render(PoseStack matrixStack, MultiBufferSource buffer, int packedLight, T player, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!PickleData.isActive(player.m_36316_().getId())) {
            return;
        }
        matrixStack.m_85836_();
        HumanoidModel parent = (HumanoidModel)this.m_117386_();
        ModelPart parentHead = parent.m_5585_();
        float bodyYRot = Mth.m_14189_((float)partialTick, (float)((Player)player).f_19859_, (float)player.m_146908_()) * ((float)Math.PI / 180);
        float bodyXRot = Mth.m_14189_((float)partialTick, (float)((Player)player).f_19860_, (float)player.m_146909_()) * ((float)Math.PI / 180);
        parentHead.m_104299_(matrixStack);
        float deltaTime = Minecraft.m_91087_().m_91297_();
        float viscosity = 0.17f;
        this.head.f_104204_ = this.rotlerpRad(deltaTime * viscosity, this.head.f_104204_, bodyYRot + parentHead.f_104204_);
        this.head.f_104203_ = this.rotlerpRad(deltaTime * viscosity, this.head.f_104203_, bodyXRot + parentHead.f_104203_);
        float k = (float)Math.PI * -2;
        this.head.f_104204_ = -bodyYRot - parentHead.f_104204_ + this.head.f_104204_ + k;
        this.head.f_104203_ = -bodyXRot - parentHead.f_104203_ + this.head.f_104203_ + k;
        float g = 0.875f;
        matrixStack.m_85841_(-g, -g, g);
        matrixStack.m_85837_(-0.5, 0.5, -0.5);
        VertexConsumer vc = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)ModTextures.JAR_MAN));
        matrixStack.m_85836_();
        matrixStack.m_252880_(0.5f, 0.0f, 0.5f);
        matrixStack.m_85841_(-1.0f, -1.0f, 1.0f);
        this.model.f_104204_ = 0.0f;
        if (!(parent.f_102818_ > 0.0f) || player.m_6067_()) {
            // empty if block
        }
        this.head.f_104201_ = 3.5f + Mth.m_14031_((float)(ageInTicks / 11.0f + limbSwing / 5.0f)) / 2.5f;
        this.eyeRight.f_104200_ = Mth.m_14089_((float)(ageInTicks / 16.0f)) / 4.0f;
        this.eyeRight.f_104201_ = Mth.m_14031_((float)(ageInTicks / 7.0f)) / 4.0f;
        this.eyeLeft.f_104200_ = Mth.m_14089_((float)(ageInTicks / 12.0f)) / 4.0f;
        this.eyeLeft.f_104201_ = Mth.m_14089_((float)(ageInTicks / 7.0f)) / 4.0f;
        this.model.m_104306_(matrixStack, vc, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.m_85849_();
        matrixStack.m_85849_();
        this.head.f_104204_ += parentHead.f_104204_ + bodyYRot - k;
        this.head.f_104203_ += parentHead.f_104203_ + bodyXRot - k;
    }

    protected float rotlerpRad(float angle, float maxAngle, float mul) {
        float f = (mul - maxAngle) % ((float)Math.PI * 2);
        if (f < (float)(-Math.PI)) {
            f += (float)Math.PI * 2;
        }
        if (f >= (float)Math.PI) {
            f -= (float)Math.PI * 2;
        }
        return maxAngle + angle * f;
    }
}

