/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import net.mehvahdjukaar.supplementaries.common.block.tiles.KeyLockableTile;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.QuarkCompat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class GoldDoorBlock
extends DoorBlock {
    public GoldDoorBlock(BlockBehaviour.Properties builder) {
        super(builder, BlockSetType.f_271208_);
    }

    public boolean canBeOpened(BlockState state) {
        return (Boolean)state.m_61143_((Property)f_52729_) == false;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (this.canBeOpened(state)) {
            GoldDoorBlock.tryOpenDoubleDoor(level, state, pos);
            state = (BlockState)state.m_61122_((Property)f_52727_);
            level.m_7731_(pos, state, 10);
            this.m_245755_((Entity)player, level, pos, (Boolean)state.m_61143_((Property)f_52727_));
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean hasPower;
        boolean bl = worldIn.m_276867_(pos) || worldIn.m_276867_(pos.m_121945_(state.m_61143_((Property)f_52730_) == DoubleBlockHalf.LOWER ? Direction.UP : Direction.DOWN)) ? true : (hasPower = false);
        if (blockIn != this && hasPower != (Boolean)state.m_61143_((Property)f_52729_)) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)f_52729_, (Comparable)Boolean.valueOf(hasPower)), 2);
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        if (state != null) {
            state.m_61124_((Property)f_52727_, (Comparable)Boolean.valueOf(false));
        }
        return state;
    }

    public static void tryOpenDoubleDoor(Level world, BlockState state, BlockPos pos) {
        if (CompatHandler.QUARK && QuarkCompat.isDoubleDoorEnabled() || CompatHandler.DOUBLEDOORS) {
            Direction direction = (Direction)state.m_61143_((Property)DoorBlock.f_52726_);
            boolean isOpen = (Boolean)state.m_61143_((Property)DoorBlock.f_52727_);
            DoorHingeSide isMirrored = (DoorHingeSide)state.m_61143_((Property)DoorBlock.f_52728_);
            BlockPos mirrorPos = pos.m_121945_(isMirrored == DoorHingeSide.RIGHT ? direction.m_122428_() : direction.m_122427_());
            BlockPos doorPos = state.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.LOWER ? mirrorPos : mirrorPos.m_7495_();
            BlockState other = world.m_8055_(doorPos);
            if (other.m_60734_() == state.m_60734_() && other.m_61143_((Property)DoorBlock.f_52726_) == direction && !((Boolean)other.m_61143_((Property)DoorBlock.f_52729_)).booleanValue() && (Boolean)other.m_61143_((Property)DoorBlock.f_52727_) == isOpen && other.m_61143_((Property)DoorBlock.f_52728_) != isMirrored) {
                BlockState newState = (BlockState)other.m_61122_((Property)DoorBlock.f_52727_);
                world.m_7731_(doorPos, newState, 10);
            }
        }
    }

    public static void tryOpenDoubleDoorKey(Level world, BlockState state, BlockPos pos, Player player, InteractionHand hand) {
        if (CompatHandler.QUARK && QuarkCompat.isDoubleDoorEnabled() || CompatHandler.DOUBLEDOORS) {
            KeyLockableTile keyLockableTile;
            BlockEntity blockEntity;
            Direction direction = (Direction)state.m_61143_((Property)DoorBlock.f_52726_);
            boolean isOpen = (Boolean)state.m_61143_((Property)DoorBlock.f_52727_);
            DoorHingeSide isMirrored = (DoorHingeSide)state.m_61143_((Property)DoorBlock.f_52728_);
            BlockPos mirrorPos = pos.m_121945_(isMirrored == DoorHingeSide.RIGHT ? direction.m_122428_() : direction.m_122427_());
            BlockPos doorPos = state.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.LOWER ? mirrorPos : mirrorPos.m_7495_();
            BlockState other = world.m_8055_(doorPos);
            if (other.m_60734_() == state.m_60734_() && other.m_61143_((Property)DoorBlock.f_52726_) == direction && (Boolean)other.m_61143_((Property)DoorBlock.f_52727_) == isOpen && other.m_61143_((Property)DoorBlock.f_52728_) != isMirrored && (blockEntity = world.m_7702_(doorPos)) instanceof KeyLockableTile && (keyLockableTile = (KeyLockableTile)blockEntity).handleAction(player, hand, "door")) {
                BlockState newState = (BlockState)other.m_61122_((Property)DoorBlock.f_52727_);
                world.m_7731_(doorPos, newState, 10);
            }
        }
    }
}

