/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.block.WaterBlock;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class WickerFenceBlock
extends WaterBlock {
    public static final EnumProperty<WallSide> EAST_WALL = BlockStateProperties.f_61378_;
    public static final EnumProperty<WallSide> NORTH_WALL = BlockStateProperties.f_61379_;
    public static final EnumProperty<WallSide> SOUTH_WALL = BlockStateProperties.f_61380_;
    public static final EnumProperty<WallSide> WEST_WALL = BlockStateProperties.f_61381_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private final Map<BlockState, VoxelShape> shapeByIndex;
    private final Map<BlockState, VoxelShape> collisionShapeByIndex;
    private static final VoxelShape NORTH_TEST = Block.m_49796_((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape SOUTH_TEST = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)16.0);
    private static final VoxelShape WEST_TEST = Block.m_49796_((double)0.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape EAST_TEST = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);
    public static final Map<Direction, EnumProperty<WallSide>> PROPERTY_BY_DIRECTION = ImmutableMap.copyOf((Map)((Map)Util.m_137469_((Object)Maps.newEnumMap(Direction.class), enumMap -> {
        enumMap.put(Direction.NORTH, NORTH_WALL);
        enumMap.put(Direction.EAST, EAST_WALL);
        enumMap.put(Direction.SOUTH, SOUTH_WALL);
        enumMap.put(Direction.WEST, WEST_WALL);
    })));

    public WickerFenceBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(NORTH_WALL, (Comparable)WallSide.NONE)).m_61124_(EAST_WALL, (Comparable)WallSide.NONE)).m_61124_(SOUTH_WALL, (Comparable)WallSide.NONE)).m_61124_(WEST_WALL, (Comparable)WallSide.NONE));
        this.shapeByIndex = this.makeShapes(1.0f, 1.0f, 16.0f, 0.0f, 14.0f, 16.0f);
        this.collisionShapeByIndex = this.makeShapes(1.0f, 1.0f, 24.0f, 0.0f, 24.0f, 24.0f);
    }

    private static VoxelShape applyWallShape(VoxelShape baseShape, WallSide height, VoxelShape lowShape, VoxelShape tallShape) {
        if (height == WallSide.TALL) {
            return Shapes.m_83110_((VoxelShape)baseShape, (VoxelShape)tallShape);
        }
        return height == WallSide.LOW ? Shapes.m_83110_((VoxelShape)baseShape, (VoxelShape)lowShape) : baseShape;
    }

    private Map<BlockState, VoxelShape> makeShapes(float width, float depth, float wallPostHeight, float wallMinY, float wallLowHeight, float wallTallHeight) {
        float f = 8.0f - width;
        float g = 8.0f + width;
        float h = 8.0f - depth;
        float i = 8.0f + depth;
        VoxelShape postShape = Block.m_49796_((double)f, (double)0.0, (double)f, (double)g, (double)wallPostHeight, (double)g);
        VoxelShape northShape = Block.m_49796_((double)h, (double)wallMinY, (double)0.0, (double)i, (double)wallLowHeight, (double)i);
        VoxelShape southShape = Block.m_49796_((double)h, (double)wallMinY, (double)h, (double)i, (double)wallLowHeight, (double)16.0);
        VoxelShape westShape = Block.m_49796_((double)0.0, (double)wallMinY, (double)h, (double)i, (double)wallLowHeight, (double)i);
        VoxelShape eastShape = Block.m_49796_((double)h, (double)wallMinY, (double)h, (double)16.0, (double)wallLowHeight, (double)i);
        VoxelShape northShapeTall = Block.m_49796_((double)h, (double)wallMinY, (double)0.0, (double)i, (double)wallTallHeight, (double)i);
        VoxelShape southShapeTall = Block.m_49796_((double)h, (double)wallMinY, (double)h, (double)i, (double)wallTallHeight, (double)16.0);
        VoxelShape weastShapeTall = Block.m_49796_((double)0.0, (double)wallMinY, (double)h, (double)i, (double)wallTallHeight, (double)i);
        VoxelShape eastShapeTall = Block.m_49796_((double)h, (double)wallMinY, (double)h, (double)16.0, (double)wallTallHeight, (double)i);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (WallSide east : EAST_WALL.m_6908_()) {
            for (WallSide north : NORTH_WALL.m_6908_()) {
                for (WallSide west : WEST_WALL.m_6908_()) {
                    for (WallSide south : SOUTH_WALL.m_6908_()) {
                        VoxelShape conbinedShape = Shapes.m_83040_();
                        conbinedShape = WickerFenceBlock.applyWallShape(conbinedShape, east, eastShape, eastShapeTall);
                        conbinedShape = WickerFenceBlock.applyWallShape(conbinedShape, west, westShape, weastShapeTall);
                        conbinedShape = WickerFenceBlock.applyWallShape(conbinedShape, north, northShape, northShapeTall);
                        conbinedShape = WickerFenceBlock.applyWallShape(conbinedShape, south, southShape, southShapeTall);
                        conbinedShape = Shapes.m_83110_((VoxelShape)conbinedShape, (VoxelShape)postShape);
                        BlockState blockState = (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(EAST_WALL, (Comparable)east)).m_61124_(WEST_WALL, (Comparable)west)).m_61124_(NORTH_WALL, (Comparable)north)).m_61124_(SOUTH_WALL, (Comparable)south);
                        builder.put((Object)((BlockState)blockState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))), (Object)conbinedShape);
                        builder.put((Object)((BlockState)blockState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true))), (Object)conbinedShape);
                    }
                }
            }
        }
        return builder.build();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shapeByIndex.get(state);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.collisionShapeByIndex.get(state);
    }

    private boolean connectsTo(BlockState state, boolean sideSolid, Direction direction) {
        Block block = state.m_60734_();
        boolean fenceGate = block instanceof FenceGateBlock && FenceGateBlock.m_53378_((BlockState)state, (Direction)direction);
        return state.m_60713_((Block)this) || !WickerFenceBlock.m_152463_((BlockState)state) && sideSolid || block instanceof IronBarsBlock || fenceGate;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level levelReader = context.m_43725_();
        BlockPos blockPos = context.m_8083_();
        BlockState state = super.m_5573_(context);
        return this.allUpdate(state, blockPos, (LevelReader)levelReader);
    }

    @NotNull
    private BlockState allUpdate(BlockState state, BlockPos blockPos, LevelReader levelReader) {
        BlockPos northPos = blockPos.m_122012_();
        BlockPos eastPos = blockPos.m_122029_();
        BlockPos southPos = blockPos.m_122019_();
        BlockPos westPos = blockPos.m_122024_();
        BlockPos abovePos = blockPos.m_7494_();
        BlockState northState = levelReader.m_8055_(northPos);
        BlockState eastState = levelReader.m_8055_(eastPos);
        BlockState southState = levelReader.m_8055_(southPos);
        BlockState westState = levelReader.m_8055_(westPos);
        BlockState aboveState = levelReader.m_8055_(abovePos);
        boolean north = this.connectsTo(northState, northState.m_60783_((BlockGetter)levelReader, northPos, Direction.SOUTH), Direction.SOUTH);
        boolean east = this.connectsTo(eastState, eastState.m_60783_((BlockGetter)levelReader, eastPos, Direction.WEST), Direction.WEST);
        boolean south = this.connectsTo(southState, southState.m_60783_((BlockGetter)levelReader, southPos, Direction.NORTH), Direction.NORTH);
        boolean weast = this.connectsTo(westState, westState.m_60783_((BlockGetter)levelReader, westPos, Direction.EAST), Direction.EAST);
        if (!(east || weast || north || south)) {
            BlockState belowState = levelReader.m_8055_(blockPos.m_7495_());
            if (belowState.m_60713_((Block)this)) {
                east = belowState.m_61143_(EAST_WALL) != WallSide.NONE;
                weast = belowState.m_61143_(WEST_WALL) != WallSide.NONE;
                north = belowState.m_61143_(NORTH_WALL) != WallSide.NONE;
                south = belowState.m_61143_(SOUTH_WALL) != WallSide.NONE;
            } else {
                east = true;
                weast = true;
                north = true;
                south = true;
            }
        }
        return this.getCorrectShape(levelReader, state, abovePos, aboveState, north, east, south, weast);
    }

    private BlockState getCorrectShape(LevelReader level, BlockState state, BlockPos pos, BlockState upState, boolean northConnection, boolean eastConnection, boolean southConnection, boolean westConnection) {
        VoxelShape voxelShape = upState.m_60812_((BlockGetter)level, pos).m_83263_(Direction.DOWN);
        return this.updateSides(state, northConnection, eastConnection, southConnection, westConnection, voxelShape);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        state = super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
        return switch (direction) {
            case Direction.DOWN -> this.allUpdate(state, currentPos, (LevelReader)level);
            case Direction.UP -> this.topUpdate((LevelReader)level, state, neighborPos, neighborState);
            default -> this.allUpdate(state, currentPos, (LevelReader)level);
        };
    }

    private static boolean isConnected(BlockState state, Property<WallSide> heightProperty) {
        return state.m_61143_(heightProperty) != WallSide.NONE;
    }

    private static boolean isCovered(VoxelShape firstShape, VoxelShape secondShape) {
        return !Shapes.m_83157_((VoxelShape)secondShape, (VoxelShape)firstShape, (BooleanOp)BooleanOp.f_82685_);
    }

    private BlockState topUpdate(LevelReader level, BlockState state, BlockPos pos, BlockState secondState) {
        boolean north = WickerFenceBlock.isConnected(state, NORTH_WALL);
        boolean east = WickerFenceBlock.isConnected(state, EAST_WALL);
        boolean south = WickerFenceBlock.isConnected(state, SOUTH_WALL);
        boolean west = WickerFenceBlock.isConnected(state, WEST_WALL);
        return this.getCorrectShape(level, state, pos, secondState, north, east, south, west);
    }

    private BlockState updateSides(BlockState state, boolean northConnection, boolean eastConnection, boolean southConnection, boolean westConnection, VoxelShape wallShape) {
        return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(NORTH_WALL, (Comparable)this.makeWallState(northConnection, wallShape, NORTH_TEST))).m_61124_(EAST_WALL, (Comparable)this.makeWallState(eastConnection, wallShape, EAST_TEST))).m_61124_(SOUTH_WALL, (Comparable)this.makeWallState(southConnection, wallShape, SOUTH_TEST))).m_61124_(WEST_WALL, (Comparable)this.makeWallState(westConnection, wallShape, WEST_TEST));
    }

    private WallSide makeWallState(boolean allowConnection, VoxelShape shape, VoxelShape neighbourShape) {
        if (allowConnection) {
            return WickerFenceBlock.isCovered(shape, neighbourShape) ? WallSide.TALL : WallSide.LOW;
        }
        return WallSide.NONE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{NORTH_WALL, EAST_WALL, WEST_WALL, SOUTH_WALL});
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return switch (rotation) {
            case Rotation.CLOCKWISE_180 -> (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(NORTH_WALL, (Comparable)((WallSide)state.m_61143_(SOUTH_WALL)))).m_61124_(EAST_WALL, (Comparable)((WallSide)state.m_61143_(WEST_WALL)))).m_61124_(SOUTH_WALL, (Comparable)((WallSide)state.m_61143_(NORTH_WALL)))).m_61124_(WEST_WALL, (Comparable)((WallSide)state.m_61143_(EAST_WALL)));
            case Rotation.COUNTERCLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(NORTH_WALL, (Comparable)((WallSide)state.m_61143_(EAST_WALL)))).m_61124_(EAST_WALL, (Comparable)((WallSide)state.m_61143_(SOUTH_WALL)))).m_61124_(SOUTH_WALL, (Comparable)((WallSide)state.m_61143_(WEST_WALL)))).m_61124_(WEST_WALL, (Comparable)((WallSide)state.m_61143_(NORTH_WALL)));
            case Rotation.CLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(NORTH_WALL, (Comparable)((WallSide)state.m_61143_(WEST_WALL)))).m_61124_(EAST_WALL, (Comparable)((WallSide)state.m_61143_(NORTH_WALL)))).m_61124_(SOUTH_WALL, (Comparable)((WallSide)state.m_61143_(EAST_WALL)))).m_61124_(WEST_WALL, (Comparable)((WallSide)state.m_61143_(SOUTH_WALL)));
            default -> state;
        };
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return switch (mirror) {
            case Mirror.LEFT_RIGHT -> (BlockState)((BlockState)state.m_61124_(NORTH_WALL, (Comparable)((WallSide)state.m_61143_(SOUTH_WALL)))).m_61124_(SOUTH_WALL, (Comparable)((WallSide)state.m_61143_(NORTH_WALL)));
            case Mirror.FRONT_BACK -> (BlockState)((BlockState)state.m_61124_(EAST_WALL, (Comparable)((WallSide)state.m_61143_(WEST_WALL)))).m_61124_(WEST_WALL, (Comparable)((WallSide)state.m_61143_(EAST_WALL)));
            default -> super.m_6943_(state, mirror);
        };
    }
}

