/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.lazrslib.client.overlay;

import com.lazrproductions.lazrslib.client.render.LazrRenderTypes;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class OverlayUtilities {
    public static void drawLabel(@Nonnull OverlayProperties p, Vec3 pos, Component text, float textScale, boolean drawShadow) {
        Minecraft inst = Minecraft.m_91087_();
        if (inst != null) {
            PoseStack stack = p.getPoseStack();
            Vec3 cameraPos = p.getCameraPos();
            Quaternionf cameraRot = p.getCameraRotation();
            Font font = inst.f_91062_;
            float scale = textScale / 50.0f;
            MultiBufferSource.BufferSource bufferSource = p.getBufferSource();
            p.getConsumerForLines();
            stack.m_85836_();
            stack.m_85837_(-cameraPos.f_82479_, -cameraPos.f_82480_, -cameraPos.f_82481_);
            double d = pos.m_7096_();
            double d2 = pos.m_7098_();
            Objects.requireNonNull(font);
            stack.m_85837_(d, d2 + (double)((float)(9 / 2) * scale), pos.m_7094_());
            stack.m_252781_(cameraRot);
            stack.m_85841_(-scale, -scale, -scale);
            stack.m_252880_((float)(-font.m_92852_((FormattedText)text)) / 2.0f, 0.0f, 0.0f);
            Matrix4f pose = stack.m_85850_().m_252922_();
            TextColor col = text.m_7383_().m_131135_();
            int color = col != null ? col.m_131265_() : -1;
            font.m_272077_(text, 0.0f, 0.0f, color, drawShadow, pose, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            p.getBufferSource().m_109911_();
            stack.m_85849_();
        }
    }

    public static void drawGrid(@Nonnull OverlayProperties p, Vec3 pos, int width, int length, float cellSize, int color) {
        for (int x = 0; x < width; ++x) {
            for (int z = 0; z < length; ++z) {
                float pX = (float)x * cellSize;
                float pZ = (float)z * cellSize;
                OverlayUtilities.drawWireSquare(p, pos.m_82520_((double)pX, 0.0, (double)pZ), cellSize, color);
            }
        }
    }

    public static void drawGridCentered(@Nonnull OverlayProperties p, Vec3 center, int width, int length, float cellSize, int color) {
        OverlayUtilities.drawGrid(p, center.m_82492_((double)((float)width * cellSize), 0.0, (double)((float)length * cellSize)), width, length, cellSize, color);
    }

    public static void drawGrid(@Nonnull OverlayProperties p, Vec3 pos, Vec3i dimensions, Vec3 cellDimensions, int color) {
        double pX = pos.m_7096_();
        double pY = pos.m_7098_();
        double pZ = pos.m_7094_();
        for (int cellX = 0; cellX < dimensions.m_123341_(); ++cellX) {
            for (int cellY = 0; cellY < dimensions.m_123342_(); ++cellY) {
                for (int cellZ = 0; cellZ < dimensions.m_123343_(); ++cellZ) {
                    OverlayUtilities.drawWireBox(p, new Vec3(pX, pY, pZ), cellDimensions, color);
                    pZ += cellDimensions.m_7094_();
                }
                pY += cellDimensions.m_7098_();
                pZ = pos.m_7094_();
            }
            pX += cellDimensions.m_7096_();
            pY = pos.m_7098_();
        }
    }

    public static void drawWireCube(@Nonnull OverlayProperties p, Vec3 pos, float size, int color) {
        OverlayUtilities.drawWireSquare(p, pos, size, color);
        OverlayUtilities.drawWireSquare(p, pos.m_82520_(0.0, (double)size, 0.0), size, color);
        OverlayUtilities.drawLine(p, pos.m_82520_(0.0, 0.0, (double)size), pos.m_82520_(0.0, (double)size, (double)size), color);
        OverlayUtilities.drawLine(p, pos.m_82520_((double)size, 0.0, (double)size), pos.m_82520_((double)size, (double)size, (double)size), color);
        OverlayUtilities.drawLine(p, pos.m_82520_(0.0, 0.0, 0.0), pos.m_82520_(0.0, (double)size, 0.0), color);
        OverlayUtilities.drawLine(p, pos.m_82520_((double)size, 0.0, 0.0), pos.m_82520_((double)size, (double)size, 0.0), color);
    }

    public static void drawWireBox(@Nonnull OverlayProperties p, Vec3 pos, Vec3 dimensions, int color) {
        double width = dimensions.m_7096_();
        double height = dimensions.m_7098_();
        double length = dimensions.m_7094_();
        if (width > 0.0) {
            OverlayUtilities.drawLine(p, pos.m_82520_(0.0, 0.0, 0.0), pos.m_82520_(width, 0.0, 0.0), color);
        }
        if (length > 0.0) {
            if (width > 0.0) {
                OverlayUtilities.drawLine(p, pos.m_82520_(width, 0.0, 0.0), pos.m_82520_(width, 0.0, length), color);
                OverlayUtilities.drawLine(p, pos.m_82520_(0.0, 0.0, length), pos.m_82520_(width, 0.0, length), color);
            }
            OverlayUtilities.drawLine(p, pos.m_82520_(0.0, 0.0, 0.0), pos.m_82520_(0.0, 0.0, length), color);
        }
        if (height > 0.0) {
            if (width > 0.0) {
                OverlayUtilities.drawLine(p, pos.m_82520_(0.0, height, 0.0), pos.m_82520_(width, height, 0.0), color);
            }
            if (length > 0.0) {
                if (width > 0.0) {
                    OverlayUtilities.drawLine(p, pos.m_82520_(width, height, 0.0), pos.m_82520_(width, height, length), color);
                    OverlayUtilities.drawLine(p, pos.m_82520_(0.0, height, length), pos.m_82520_(width, height, length), color);
                }
                OverlayUtilities.drawLine(p, pos.m_82520_(0.0, height, 0.0), pos.m_82520_(0.0, height, length), color);
            }
            if (length > 0.0) {
                OverlayUtilities.drawLine(p, pos.m_82520_(0.0, 0.0, length), pos.m_82520_(0.0, height, length), color);
            }
            if (width > 0.0 && length > 0.0) {
                OverlayUtilities.drawLine(p, pos.m_82520_(width, 0.0, length), pos.m_82520_(width, height, length), color);
            }
            OverlayUtilities.drawLine(p, pos.m_82520_(0.0, 0.0, 0.0), pos.m_82520_(0.0, height, 0.0), color);
            if (width > 0.0) {
                OverlayUtilities.drawLine(p, pos.m_82520_(width, 0.0, 0.0), pos.m_82520_(width, height, 0.0), color);
            }
        }
    }

    public static void drawWireSquare(@Nonnull OverlayProperties p, Vec3 pos, float size, int color) {
        OverlayUtilities.drawLine(p, pos.m_82520_(0.0, 0.0, 0.0), pos.m_82520_((double)size, 0.0, 0.0), color);
        OverlayUtilities.drawLine(p, pos.m_82520_((double)size, 0.0, 0.0), pos.m_82520_((double)size, 0.0, (double)size), color);
        OverlayUtilities.drawLine(p, pos.m_82520_(0.0, 0.0, 0.0), pos.m_82520_(0.0, 0.0, (double)size), color);
        OverlayUtilities.drawLine(p, pos.m_82520_(0.0, 0.0, (double)size), pos.m_82520_((double)size, 0.0, (double)size), color);
    }

    public static void drawWireSquareCentered(@Nonnull OverlayProperties p, Vec3 pos, float size, int color) {
        OverlayUtilities.drawWireSquare(p, pos.m_82492_((double)(size / 2.0f), 0.0, (double)(size / 2.0f)), size, color);
    }

    public static void drawLine(@Nonnull OverlayProperties p, Vec3 from, Vec3 to, int color) {
        OverlayUtilities.drawLine(p, (float)from.m_7096_(), (float)from.m_7098_(), (float)from.m_7094_(), (float)to.m_7096_(), (float)to.m_7098_(), (float)to.m_7094_(), color);
    }

    public static void drawLine(@Nonnull OverlayProperties p, float fromX, float fromY, float fromZ, float toX, float toY, float toZ, int color) {
        PoseStack stack = p.getPoseStack();
        Vec3 cameraPos = p.getCameraPos();
        VertexConsumer consumer = p.getConsumerForLines();
        stack.m_85836_();
        stack.m_85837_(-cameraPos.f_82479_, -cameraPos.f_82480_, -cameraPos.f_82481_);
        Matrix4f model = stack.m_85850_().m_252922_();
        if (model != null) {
            float red = (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f;
            float green = (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f;
            float blue = (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f;
            consumer.m_252986_(model, fromX, fromY, fromZ).m_85950_(red, green, blue, 1.0f).m_5752_();
            consumer.m_252986_(model, toX, toY, toZ).m_85950_(red, green, blue, 1.0f).m_5752_();
        }
        p.getBufferSource().m_109911_();
        stack.m_85849_();
    }

    public static class OverlayProperties {
        final Camera camera;
        final RenderBuffers buffers;
        final PoseStack stack;

        public OverlayProperties(@Nonnull Camera camera, @Nonnull PoseStack stack, @Nonnull RenderBuffers buffers) {
            this.camera = camera;
            this.buffers = buffers;
            this.stack = stack;
        }

        public Vec3 getCameraPos() {
            return this.camera.m_90583_();
        }

        public Quaternionf getCameraRotation() {
            return this.camera.m_253121_();
        }

        public Entity getCameraEntity() {
            return this.camera.m_90592_();
        }

        public VertexConsumer getConsumerForLines() {
            RenderType r = RenderType.m_269399_((double)2.0);
            return this.buffers.m_110104_().m_6299_(r);
        }

        public VertexConsumer getConsumerForSolid() {
            RenderType r = LazrRenderTypes.overlaySolidRenderType();
            return this.buffers.m_110104_().m_6299_(r);
        }

        public MultiBufferSource.BufferSource getBufferSource() {
            return this.buffers.m_110104_();
        }

        public PoseStack getPoseStack() {
            return this.stack;
        }
    }
}

