/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.lazrslib.client.ui.element;

import com.lazrproductions.lazrslib.client.font.FontUtilities;
import com.lazrproductions.lazrslib.client.screen.base.BlitCoordinates;
import com.lazrproductions.lazrslib.client.screen.base.ScreenRect;
import com.lazrproductions.lazrslib.client.ui.Alignment;
import com.lazrproductions.lazrslib.client.ui.element.AbstractElement;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class LabelElement
extends AbstractElement {
    final Component text;
    final Alignment alignment;
    final int width;
    final int color;

    public LabelElement(@Nonnull Minecraft instance, @Nonnull Component text, @Nonnull Alignment alignment, int color) {
        Objects.requireNonNull(instance.f_91062_);
        super(instance, 9);
        this.text = text;
        this.alignment = alignment;
        this.color = color;
        this.width = 0;
    }

    public LabelElement(@Nonnull Minecraft instance, @Nonnull Component text, @Nonnull Alignment alignment, int color, int height) {
        super(instance, height);
        this.text = text;
        this.alignment = alignment;
        this.color = color;
        this.width = 0;
    }

    public LabelElement(@Nonnull Minecraft instance, @Nonnull Component text, @Nonnull Alignment alignment, int color, int width, int height) {
        super(instance, height);
        this.text = text;
        this.alignment = alignment;
        this.color = color;
        this.width = width;
    }

    @Override
    public void draw(@Nonnull Minecraft instance, @Nonnull GuiGraphics graphics, @Nonnull ScreenRect area, int mouseX, int mouseY, boolean mouseDown) {
        int wrappedHeight = instance.f_91062_.m_239133_((FormattedText)this.text, area.getWidth());
        BlitCoordinates blitCoordinates = area.toBlitCoordinates();
        Objects.requireNonNull(instance.f_91062_);
        BlitCoordinates pos = this.alignment.fitToArea(blitCoordinates, wrappedHeight <= 9 ? instance.f_91062_.m_92852_((FormattedText)this.text) : area.getWidth(), wrappedHeight);
        if (this.width > 0) {
            BlitCoordinates blitCoordinates2 = area.toBlitCoordinates().withWidth(this.width);
            Objects.requireNonNull(instance.f_91062_);
            pos = this.alignment.fitToArea(blitCoordinates2, wrappedHeight <= 9 ? instance.f_91062_.m_92852_((FormattedText)this.text) : this.width, wrappedHeight);
        }
        FontUtilities.drawParagraph(instance, graphics, pos, List.of(this.text), this.color, false);
    }
}

