/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.lazrslib.client.ui.element;

import com.lazrproductions.lazrslib.client.screen.base.BlitCoordinates;
import com.lazrproductions.lazrslib.client.ui.element.HorizontalElement;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;

public class VerticalElement {
    BlitCoordinates pos;
    final HorizontalElement[] horizontals;
    final int height;
    final int spacing;

    public VerticalElement(@Nonnull BlitCoordinates availableArea, HorizontalElement ... horizontals) {
        this.pos = availableArea;
        this.horizontals = horizontals;
        this.height = this.calculateHeight();
        this.spacing = 0;
    }

    public VerticalElement(@Nonnull BlitCoordinates availableArea, int spacing, HorizontalElement ... horizontals) {
        this.pos = availableArea;
        this.horizontals = horizontals;
        this.height = this.calculateHeight();
        this.spacing = spacing;
    }

    public int draw(@Nonnull Minecraft instance, @Nonnull GuiGraphics graphics, int mouseX, int mouseY, boolean mouseDown) {
        int spacing = 0;
        for (int i = 0; i < this.horizontals.length; ++i) {
            spacing += this.horizontals[i].draw(instance, graphics, this.pos.move(0, spacing), mouseX, mouseY, mouseDown) + this.spacing;
        }
        return spacing;
    }

    public int drawDebug(@Nonnull Minecraft instance, @Nonnull GuiGraphics graphics) {
        int spacing = 0;
        for (int i = 0; i < this.horizontals.length; ++i) {
            spacing += this.horizontals[i].drawDebug(instance, graphics, this.pos.move(0, spacing), i) + this.spacing;
        }
        return spacing;
    }

    public void setAvailableArea(@Nonnull BlitCoordinates newArea) {
        this.pos = newArea;
    }

    int calculateHeight() {
        int spacing = 0;
        for (int i = 0; i < this.horizontals.length; ++i) {
            spacing += this.horizontals[i].calculateHeight(this.horizontals[i].elements);
        }
        return spacing;
    }
}

